<?php

use \UtillzCore\Inc\Src\Admin\Panel;
use \UtillzCore\Templates\Admin\Metabox\Field_Column_Sizes;

defined('ABSPATH') || exit;

// Now you can use the Panel class
$panel = Panel::instance();
$panelForm = $panel->getForm();
$panelForm->set($panelForm::Storage_Meta);

?>

<div class="ulz-panel ulz-loading ulz-outer" id="ulz-panel" data-tab-start="general/setup" :class="{ 'ulz-ready' : ready }">

    <input type="hidden" name="utillz_current_tab" v-bind:value="tab">

    <div class="ulz-header">

        <div class="ulz-site-logo">
            <h3 class="ulz--name"><a href="https://utillz.com" target="_blank"><?php esc_html_e('Utillz', 'utillz-core'); ?></a></h3>
        </div>

        <nav class="ulz-nav">
            <ul>
                <li :class="{ 'ulz-active': tabMain == 'general' }">
                    <a href="#" v-on:click.prevent="tabClick('general/setup')">
                        <?php esc_html_e( 'General', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabMain == 'listing' }">
                    <a href="#" v-on:click.prevent="tabClick('listing/fields')">
                        <?php esc_html_e( 'Listing', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabMain == 'display' }">
                    <a href="#" v-on:click.prevent="tabClick('display/box')">
                        <?php esc_html_e( 'Display', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabMain == 'explore' }">
                    <a href="#" v-on:click.prevent="tabClick('explore/general')">
                        <?php esc_html_e( 'Explore', 'utillz-core' ); ?>
                    </a>
                </li>

                <li :class="{ 'ulz-active': tabMain == 'monetize' }">
                    <a href="#" v-on:click.prevent="tabClick('monetize/plans')">
                        <?php esc_html_e( 'Monetize', 'utillz-core' ); ?>
                    </a>
                </li>
            </ul>
        </nav>

        <div class="ulz-header-guide ulz-ml-auto">
            <a href="https://utillz.com/docs/" class="ulz-docs" target="_blank">
                <div class="ulz--icon ulz-mr-1">
                    <i class="material-icons">collections_bookmark</i>
                </div>
                <div class="ulz--content">
                    <?php esc_html_e('User Guide', 'utillz-core'); ?>
                </div>
            </a>
        </div>

    </div> <!-- ulz-header -->

    <div class="ulz-sub-navs">

        <!-- general -->
        <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'general'">
            <li :class="{ 'ulz-active': tabSub == 'setup' }">
                <a href="#" v-on:click.prevent="tabClick('general/setup')">
                    <?php esc_html_e( 'Setup', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'submission' }">
                <a href="#" v-on:click.prevent="tabClick('general/submission')">
                    <?php esc_html_e( 'Submission', 'utillz-core' ); ?>
                </a>
            </li>
        </ul>

        <!-- listing -->
        <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'listing'">
            <li :class="{ 'ulz-active': tabSub == 'fields' }">
                <a href="#" v-on:click.prevent="tabClick('listing/fields')">
                    <?php esc_html_e( 'Fields', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'action' }">
                <a href="#" v-on:click.prevent="tabClick('listing/action')">
                    <?php esc_html_e( 'Action', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'pricing' }">
                <a href="#" v-on:click.prevent="tabClick('listing/pricing')">
                    <?php esc_html_e( 'Pricing', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'reviews' }">
                <a href="#" v-on:click.prevent="tabClick('listing/reviews')">
                    <?php esc_html_e( 'Reviews', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'related' }">
                <a href="#" v-on:click.prevent="tabClick('listing/related')">
                    <?php esc_html_e( 'Related', 'utillz-core' ); ?>
                </a>
            </li>
        </ul>

        <!-- display -->
        <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'display'">
            <li :class="{ 'ulz-active': tabSub == 'box' }">
                <a href="#" v-on:click.prevent="tabClick('display/box')">
                    <?php esc_html_e( 'Listing Box', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'single' }">
                <a href="#" v-on:click.prevent="tabClick('display/single')">
                    <?php esc_html_e( 'Single Page', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'marker' }">
                <a href="#" v-on:click.prevent="tabClick('display/marker')">
                    <?php esc_html_e( 'Map Marker', 'utillz-core' ); ?>
                </a>
            </li>
        </ul>

        <!-- explore -->
        <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'explore'">
            <li :class="{ 'ulz-active': tabSub == 'general' }">
                <a href="#" v-on:click.prevent="tabClick('explore/general')">
                    <?php esc_html_e( 'General', 'utillz-core' ); ?>
                </a>
            </li>
        </ul>

        <!-- monetize -->
        <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'monetize'">
            <li :class="{ 'ulz-active': tabSub == 'plans' }">
                <a href="#" v-on:click.prevent="tabClick('monetize/plans')">
                    <?php esc_html_e( 'Plans', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'promotions' }">
                <a href="#" v-on:click.prevent="tabClick('monetize/promotions')">
                    <?php esc_html_e( 'Promotions', 'utillz-core' ); ?>
                </a>
            </li>
            <li :class="{ 'ulz-active': tabSub == 'payments' }">
                <a href="#" v-on:click.prevent="tabClick('monetize/payments')">
                    <?php esc_html_e( 'Payments', 'utillz-core' ); ?>
                </a>
            </li>
        </ul>

    </div>

    <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'general'}">

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'setup'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'General', 'utillz-core' ); ?></h3>
            </div>

            <div class="ulz-form">
                <div class="ulz-grid">
					<?php

					$panel = Panel::instance();
					$form = $panel->getForm();

					$form->render([
					'type' => 'text',
					'id' => 'name',
					'name' => esc_html__('Listing singular name', 'utillz-core'),
					'col' => 4,
					]);

					$form->render([
					'type' => 'text',
					'id' => 'name_plural',
					'name' => esc_html__('Listing plural name', 'utillz-core'),
					'col' => 4,
					]);

					$form->render([
					'type' => 'key',
					'id' => 'slug',
					'name' => esc_html__('Listing slug', 'utillz-core'),
					'placeholder' => 'listing-slug',
					'col' => 4,
					'defined' => false,
					]);

					$form->render([
					'type' => 'icon',
					'id' => 'icon',
					'name' => esc_html__('Listing icon', 'utillz-core'),
					]);
					?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </div>

        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'submission'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'General', 'utillz-core' ); ?></h3>
            </div>

            <div class="ulz-form">
                <div class="ulz-grid">
				<?php

				// Now you can use the Panel class
				$panel = Panel::instance();
				$form = $panel->getForm();

				$form->render([
				'type' => 'checkbox',
				'id' => 'requires_admin_approval',
				'name' => esc_html__( 'Requires admin approval', 'utillz-core' ),
				'description' => esc_html__( 'Listing submissions under this group will be inserted as "draft" and will be pending for admin approval in order to be visible.', 'utillz-core' ),
				]);

				$form->render([
				'type' => 'checkbox',
				'id' => 'requires_admin_approval_after_update',
				'name' => esc_html__( 'Requires admin approval after update', 'utillz-core' ),
				'description' => esc_html__( 'After user update the status of the listing will be changed to "Pending".', 'utillz-core' ),
				]);

				$form->render([
				'type' => 'checkbox',
				'id' => 'disable_user_submission',
				'name' => esc_html__('Disable front-end submission', 'utillz-core'),
				]);

				$form->render([
				'type' => 'checkbox',
				'id' => 'gallery_as_featured',
				'name' => esc_html__( 'Use the gallery first image as featured image', 'utillz-core' ),
				]);

				?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>

            </div>

        </aside>

    </section>

    <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'listing'}">
        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'fields'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'Fields', 'utillz-core' ); ?></h3>
                <p>
                    <?php esc_html_e( 'Customize your listing fields. Organize and group multiple field into sections using the "Tab" module. Every tab group will appear as a new step in the submission form', 'utillz-core' ); ?>
                </p>
            </div>

            <div class="ulz-form ulz-grid">
                <?php
					
					// Now you can use the Panel class
						$panel = Panel::instance();
						$form = $panel->getForm();

						$form->render([
						'type' => 'repeater',
						'id' => 'fields',

						'name' => esc_html__('Fields', 'utillz-core'),
						'templates' => [

                            /*
                             * free text, html, shortcode support
                             *
                             */
                            'plain-text' => [
                                'name' => esc_html__( 'Static content — free text', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'content' => [
                                        'type' => 'textarea',
                                        'name' => esc_html__( 'Content', 'utillz-core' ),
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * text
                             *
                             */
                            'text' => [
                                'name' => esc_html__( 'Text', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'placeholder' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Placeholder', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * textarea
                             *
                             */
                            'textarea' => [
                                'name' => esc_html__( 'Textarea', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'placeholder' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Placeholder', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * checkbox
                             *
                             */
                            'checkbox' => [
                                'name' => esc_html__( 'Checkbox', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * number
                             *
                             */
                            'number' => [
                                'name' => esc_html__( 'Number', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'input_type' => [
                                        'type' => 'select',
                                        'name' => esc_html__('Input type', 'utillz-core'),
                                        'value' => 'number',
                                        'options' => [
                                            'number' => esc_html__('Number', 'utillz-core'),
                                            'range' => esc_html__('Range', 'utillz-core'),
                                            'stepper' => esc_html__('Stepper', 'utillz-core'),
                                        ],
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'style' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Style', 'utillz-core' ),
                                        'options' => [
                                            'v1' => 'V1',
                                            'v2' => 'V2',
                                        ],
                                        'value' => 'v1',
                                        'allow_empty' => false,
                                        'dependency' => [
                                            'id' => 'input_type',
                                            'compare' => '=',
                                            'value' => 'stepper',
                                        ],
                                    ],
                                    'format' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Format', 'utillz-core' ),
                                        'value' => '%s',
                                        'dependency' => [
                                            'id' => 'input_type',
                                            'compare' => '=',
                                            'value' => [ 'range', 'stepper' ],
                                        ],
                                    ],
                                    'min' => [
                                        'type' => 'number',
                                        'name' => esc_html__( 'Minimum value', 'utillz-core' ),
                                        'col' => 6,
                                    ],
                                    'max' => [
                                        'type' => 'number',
                                        'name' => esc_html__( 'Maximum value', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'step' => [
                                        'type' => 'number',
                                        'name' => esc_html__( 'Step size', 'utillz-core' ),
                                        'step' => 0.01,
                                        'col' => 6
                                    ],
                                    'value' => [
                                        'type' => 'number',
                                        'name' => esc_html__( 'Value', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * selection
                             *
                             */
                            'choice' => [
                                'name' => esc_html__( 'Selection', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'choice' => [
                                        'type' => 'select',
                                        'name' => esc_html__('Type', 'utillz-core'),
                                        'value' => 'select',
                                        'options' => [
                                            'select' => esc_html__('Select', 'utillz-core'),
                                            'radio' => esc_html__('Radio buttons', 'utillz-core'),
                                            'checklist' => esc_html__('Checkboxes', 'utillz-core'),
                                        ],
                                        'allow_empty' => false,
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'options' => [
                                        'type' => 'options',
                                        'name' => esc_html__( 'Options', 'utillz-core' ),
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * taxonomy
                             *
                             */
                            'taxonomy' => [
                                'name' => esc_html__( 'Selection — Taxonomy', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'taxonomy_types',
                                        'name' => esc_html__('Taxonomy', 'utillz-core'),
                                        'col' => 6,
                                        'allow_empty' => false
                                    ],
                                    'display' => [
                                        'type' => 'select',
                                        'name' => esc_html__('Type', 'utillz-core'),
                                        'value' => 'select',
                                        'options' => apply_filters('utillz/form/field/taxonomy/options', [
                                            'select' => esc_html__('Select', 'utillz-core'),
                                            'checklist' => esc_html__('Checkboxes', 'utillz-core'),
                                            'radio' => esc_html__('Radio buttons', 'utillz-core'),
                                        ]),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'columns' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Term columns', 'utillz-core' ),
                                        'value' => 1,
                                        'options' => [
                                            1 => 1,
                                            2 => 2,
                                            3 => 3,
                                        ],
                                        'allow_empty' => false,
                                        'dependency' => [
                                            'id' => 'display',
                                            'compare' => '=',
                                            'value' => [ 'checklist' ],
                                        ],
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],
							
                                        /*
                                         * editor
                                         *
                                         */
                                        'editor' => [
                                            'name' => esc_html__( 'Editor', 'utillz-core' ),
                                            'heading' => 'name',
                                            'fields' => [
                                                'name' => [
                                                    'type' => 'text',
                                                    'name' => esc_html__( 'Name', 'utillz-core' ),
                                                    'col' => 6
                                                ],
                                                'key' => [
                                                    'type' => 'key',
                                                    'name' => esc_html__( 'Key', 'utillz-core' ),
                                                    'col' => 6
                                                ],
                                                'description' => [
                                                    'type' => 'text',
                                                    'name' => esc_html__( 'Description', 'utillz-core' ),
                                                ],
                                                'required' => [
                                                    'type' => 'checkbox',
                                                    'name' => esc_html__( 'Required Field', 'utillz-core' ),
                                                    'col' => 6
                                                ],
                                                'is_submit_form' => [
                                                    'type' => 'checkbox',
                                                    'name' => esc_html__( 'Show in Submission Form', 'utillz-core' ),
                                                    'value' => true,
                                                    'col' => 6
                                                ],
                                                'is_admin_page' => [
                                                    'type' => 'checkbox',
                                                    'name' => esc_html__( 'Show in Admin Edit Page', 'utillz-core' ),
                                                    'value' => true,
                                                    'col' => 6
                                                ],
                                                'col' => [
                                                    'type' => 'select',
                                                    'name' => esc_html__( 'Column Size', 'utillz-core' ),
                                                    'value' => 12,
                                                    'options' => [
                                                        12 => esc_html__('100%', 'utillz-core'),
                                                        6 => esc_html__('50%', 'utillz-core'),
                                                        4 => esc_html__('25%', 'utillz-core'),
                                                        3 => esc_html__('20%', 'utillz-core'),
                                                    ],
                                                    'allow_empty' => false,
                                                    'col' => 6
                                                ]
                                            ]
                                        ],
							
							 /*
                                         * faq
                                         *
                                         */
                                        'faq' => [
                                            'name' => esc_html__( 'Faq', 'utillz-core' ),
                                            'heading' => 'name',
                                            'fields' => [
                                                'name' => [
                                                    'type' => 'text',
                                                    'name' => esc_html__( 'Name', 'utillz-core' ),
                                                    'col' => 6
                                                ],
                                                'key' => [
                                                    'type' => 'key',
                                                    'name' => esc_html__( 'Key', 'utillz-core' ),
                                                    'col' => 6
                                                ],
                                                'description' => [
                                                    'type' => 'text',
                                                    'name' => esc_html__( 'Description', 'utillz-core' ),
                                                ],
                                                'required' => [
                                                    'type' => 'checkbox',
                                                    'name' => esc_html__( 'Required Field', 'utillz-core' ),
                                                    'col' => 6
                                                ],
                                                'is_submit_form' => [
                                                    'type' => 'checkbox',
                                                    'name' => esc_html__( 'Show in Submission Form', 'utillz-core' ),
                                                    'value' => true,
                                                    'col' => 6
                                                ],
                                                'is_admin_page' => [
                                                    'type' => 'checkbox',
                                                    'name' => esc_html__( 'Show in Admin Edit Page', 'utillz-core' ),
                                                    'value' => true,
                                                    'col' => 6
                                                ],
                                                'col' => [
                                                    'type' => 'select',
                                                    'name' => esc_html__( 'Column Size', 'utillz-core' ),
                                                    'value' => 12,
                                                    'options' => [
                                                        12 => esc_html__('100%', 'utillz-core'),
                                                        6 => esc_html__('50%', 'utillz-core'),
                                                        4 => esc_html__('25%', 'utillz-core'),
                                                        3 => esc_html__('20%', 'utillz-core'),
                                                    ],
                                                    'allow_empty' => false,
                                                    'col' => 6
                                                ]
                                            ]
                                        ],

							

                            /*
                             * upload
                             *
                             */
                            'upload' => [
                                'name' => esc_html__( 'Upload', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'col' => 6,
                                        'value' => 'ulz_gallery'
                                    ],
                                    'multiple_upload' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Allow multiple uploads?', 'utillz-core' ),
                                    ],
                                    'upload_type' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Upload type', 'utillz-core' ),
                                        'value' => 'image',
                                        'options' => [
                                            'image' => esc_html__( 'Image', 'utillz-core' ),
                                            'file' => esc_html__( 'File', 'utillz-core' ),
                                        ],
                                        'allow_empty' => false,
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * map
                             *
                             */
                            'map' => [
                                'name' => esc_html__( 'Location', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'value' => 'ulz_location',
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                    ],
                                    'default' => [
                                        'type' => 'map',
                                        'name' => esc_html__( 'Default location', 'utillz-core' ),
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * menu
                             *
                             */
                            'menu' => [
                                'name' => esc_html__( 'Menu', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'hidden',
                                        'value' => 'ulz_menu',
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                ]
                            ],

                            /*
                             * collection
                             *
                             */
                            'collection' => [
                                'name' => esc_html__( 'Collection', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Description', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'hidden',
                                        'value' => 'ulz_collection',
                                    ],
                                    'required' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Required field', 'utillz-core' ),
                                        'col' => 6
                                    ],
                                    'is_submit_form' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in submission form', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                        'col' => 6
                                    ],
                                    'col' => [
                                        'type' => 'select',
                                        'name' => esc_html__( 'Column size', 'utillz-core' ),
                                        'value' => 12,
                                        'options' => Field_Column_Sizes::get(),
                                        'allow_empty' => false,
                                        'col' => 6
                                    ]
                                ]
                            ],

                            /*
                             * tab
                             *
                             */
                            'tab' => [
                                'name' => esc_html__( 'Tab', 'utillz-core' ),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                    ],
                                    'icon' => [
                                        'type' => 'icon',
                                        'name' => esc_html__( 'Icon', 'utillz-core' ),
                                    ],
                                    'is_admin_page' => [
                                        'type' => 'hidden',
                                        'name' => esc_html__( 'Show in admin edit page', 'utillz-core' ),
                                        'value' => true,
                                    ],
                                ]
                            ],

                        ]
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'action'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e('Action', 'utillz-core'); ?></h3>
            </div>

            <div class="ulz-form ulz-grid">

                <?php
						$panel = Panel::instance();
						$form = $panel->getForm();

						$form->render([
                        'type' => 'repeater',
                        'id' => 'action_types',
                        'name' => esc_html__('Action types', 'utillz-core'),
                        'button' => [
                            'label' => esc_html__('Add action type', 'utillz-core')
                        ],
                        'templates' => array_merge([

                            /*
                             * free text, html, shortcode support
                             *
                             */
                            'plain-text' => [
                                'name' => esc_html__('Static content — free text', 'utillz-core'),
                                'fields' => [
                                    'text' => [
                                        'type' => 'textarea',
                                        'name' => esc_html__( 'Content', 'utillz-core' ),
                                    ]
                                ]
                            ],

                            /*
                             * button
                             *
                             */
                            'button' => [
                                'name' => esc_html__('Button', 'utillz-core'),
                                'fields' => [
                                    'enable_author' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Display author details', 'utillz-core' ),
                                        'value' => true,
                                    ],
                                    'botton_target_blank' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Open in a new tab?', 'utillz-core' ),
                                    ],
                                    'request_login' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Request login?', 'utillz-core' ),
                                        'description' => esc_html__( 'If you check this option, only logged in users will be able to click the button.', 'utillz-core' ),
                                    ],
                                    'title' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Custom title', 'utillz-core' ),
                                    ],
                                    'meta' => [
                                        'type' => 'repeater',
                                        'name' => esc_html__('Fields', 'utillz-core'),
                                        'description' => esc_html__('Add additional fields', 'utillz-core'),
                                        'button' => [
                                            'label' => esc_html__('Add field', 'utillz-core')
                                        ],
                                        'templates' => [

                                            'field' => [
                                                'name' => esc_html__('Text field', 'utillz-core'),
                                                'heading' => 'name',
                                                'fields' => [
                                                    'name' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                                        'value' => esc_html__( 'Field name', 'utillz-core' )
                                                    ],
                                                    'id' => [
                                                        'type' => 'use_field',
                                                        'name' => esc_html__('Select field', 'utillz-core'),
                                                        'description' => esc_html__('Select field to display', 'utillz-core'),
                                                        'exclude' => [
                                                            'post_title',
                                                            'post_content',
                                                        ],
                                                        'include' => [
                                                            'ulz_location' => esc_html__('Address', 'utillz-core')
                                                        ],
                                                        'col' => 6
                                                    ],
                                                    'format' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__('Format', 'utillz-core'),
                                                        'description' => esc_html__('{field} will be replaced with the field value. You can add additional text, example format: "{field} bedrooms", will print "4 bedrooms".', 'utillz-core'),
                                                        'value' => '{field}',
                                                        'col' => 6
                                                    ],
                                                    'icon' => [
                                                        'type' => 'icon',
                                                        'name' => esc_html__( 'Icon', 'utillz-core' )
                                                    ],
                                                    'type' => [
                                                        'type' => 'select',
                                                        'name' => esc_html__('Type', 'utillz-core'),
                                                        'options' => [
                                                            'text' => esc_html__('Text', 'utillz-core'),
                                                            'address' => esc_html__('Address', 'utillz-core'),
                                                            'url' => esc_html__('URL', 'utillz-core'),
                                                            'email' => esc_html__('Email', 'utillz-core'),
                                                            'phone' => esc_html__('Phone number', 'utillz-core'),
                                                            'price' => esc_html__('Price', 'utillz-core'),
                                                        ],
                                                        'allow_empty' => false
                                                    ],
                                                    'type_url_label' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__( 'URL text', 'utillz-core' ),
                                                        'dependency' => [
                                                            'id' => 'type',
                                                            'compare' => '=',
                                                            'value' => [ 'url' ],
                                                        ],
                                                    ],
                                                ]
                                            ],

                                        ],
                                    ],
                                    'show_button' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Show button', 'utillz-core' ),
                                        'value' => true,
                                    ],
                                    'button_label' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Button label', 'utillz-core' ),
                                        'placeholder' => esc_html__( 'Button', 'utillz-core' ),
                                    ],
                                    'button_field' => [
                                        'type' => 'use_field',
                                        'name' => esc_html__('Select button field', 'utillz-core'),
                                        'description' => esc_html__('Select the field you want to be used for the button url', 'utillz-core'),
                                        'exclude' => [
                                            'post_title',
                                            'post_content',
                                        ]
                                    ],
                                    'hide_if_field_empty' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Hide action type if the field value is empty', 'utillz-core' ),
                                    ],
                                ]
                            ],

                            /*
                             * contact
                             *
                             */
                            'contact' => [
                                'name' => esc_html__('Contact', 'utillz-core'),
                                'fields' => [
                                    'enable_author' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Display author details', 'utillz-core' ),
                                        'value' => true,
                                    ]
                                ]
                            ],

                            /*
                             * application
                             *
                             */
                            'application' => [
                                'name' => esc_html__('Application form', 'utillz-core'),
                                'fields' => [
                                    'enable_author' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Display author details', 'utillz-core' ),
                                        'value' => true,
                                    ],
                                    'application_button_label' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Application button label', 'utillz-core' ),
                                        'placeholder' => esc_html__( 'Send application', 'utillz-core' ),
                                    ],
                                    'form' => UtillzCore\Templates\Admin\Metabox\Application_Fields::get(),
                                ]
                            ],

                            /*
                             * location
                             *
                             */
                            'location' => [
                                'name' => esc_html__('Location', 'utillz-core'),
                                'fields' => [
                                    'fields' => [

                                        'type' => 'repeater',
                                        'id' => 'action_type_location_fields',
                                        'name' => esc_html__('Location fields', 'utillz-core'),
                                        'description' => esc_html__('Add additional fields', 'utillz-core'),
                                        'button' => [
                                            'label' => esc_html__('Add field', 'utillz-core')
                                        ],
                                        'templates' => [

                                            'field' => [
                                                'name' => esc_html__('Text field', 'utillz-core'),
                                                'heading' => 'name',
                                                'fields' => [
                                                    'name' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                                        'value' => esc_html__( 'Field name', 'utillz-core' )
                                                    ],
                                                    'id' => [
                                                        'type' => 'use_field',
                                                        'name' => esc_html__('Select field', 'utillz-core'),
                                                        'description' => esc_html__('Select field to display', 'utillz-core'),
                                                        'exclude' => [
                                                            'post_title',
                                                            'post_content',
                                                        ],
                                                        'include' => [
                                                            'ulz_location' => esc_html__('Address', 'utillz-core')
                                                        ],
                                                        'col' => 6
                                                    ],
                                                    'format' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__('Format', 'utillz-core'),
                                                        'description' => esc_html__('{field} will be replaced with the field value. You can add additional text, example format: "{field} bedrooms", will print "4 bedrooms".', 'utillz-core'),
                                                        'value' => '{field}',
                                                        'col' => 6
                                                    ],
                                                    'icon' => [
                                                        'type' => 'icon',
                                                        'name' => esc_html__( 'Icon', 'utillz-core' )
                                                    ],
                                                    'type' => [
                                                        'type' => 'select',
                                                        'name' => esc_html__('Type', 'utillz-core'),
                                                        'options' => [
                                                            'text' => esc_html__('Text', 'utillz-core'),
                                                            'address' => esc_html__('Address', 'utillz-core'),
                                                            'url' => esc_html__('URL', 'utillz-core'),
                                                            'email' => esc_html__('Email', 'utillz-core'),
                                                            'phone' => esc_html__('Phone number', 'utillz-core'),
                                                            'price' => esc_html__('Price', 'utillz-core'),
                                                        ],
                                                        'allow_empty' => false
                                                    ],
                                                    'type_url_label' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__( 'URL text', 'utillz-core' ),
                                                        'dependency' => [
                                                            'id' => 'type',
                                                            'compare' => '=',
                                                            'value' => [ 'url' ],
                                                        ],
                                                    ],
                                                ]
                                            ],

                                        ],

                                    ]
                                ]
                            ],

                            /*
                             * purchase
                             *
                             */
                            'purchase' => [
                                'name' => esc_html__('Purchase button', 'utillz-core'),
                                'fields' => [
                                    'action_type_product' => [
                                        'type' => 'wc_products',
                                        'name' => esc_html__( 'Select product', 'utillz-core' ),
                                        'description' => esc_html__('The WooCommerce product of type `Listing Purchase` that will be used to create order.', 'utillz-core'),
                                        'product_type' => 'listing_purchase',
                                        'choice' => 'select',
                                        'allow_empty' => true,
                                        'error_message' => esc_html__( 'There are no available listing purchase products, please create one by going to Products > Add New with the type "Listing Purchase"', 'utillz-core' ),
                                    ],
                                    'button_label' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Button label', 'utillz-core' ),
                                        'placeholder' => esc_html__( 'Purchase', 'utillz-core' ),
                                    ],
                                    'title' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Title (optional)', 'utillz-core' ),
                                    ],
                                    'description' => [
                                        'type' => 'textarea',
                                        'name' => esc_html__( 'Summary (optional)', 'utillz-core' ),
                                    ],
                                ]
                            ],

                            /*
                             * bullets list
                             *
                             */
                            'bullets' => [
                                'name' => 'Ordered list',
                                'heading' => 'name',
                                'fields' => [
                                    'disc' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__( 'Disc', 'utillz-core' ),
                                    ],
                                    'title' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Title (optional)', 'utillz-core' ),
                                    ],
                                    'description' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Summary (optional)', 'utillz-core' ),
                                    ],

                                    'items' => [
                                        'type' => 'repeater',
                                        'name' => esc_html__('Meta items', 'utillz-core'),
                                        'templates' => [

                                            'item' => [
                                                'name' => 'Item',
                                                'heading' => 'name',
                                                'fields' => [
                                                    'name' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__('Name', 'utillz-core'),
                                                    ],
                                                    'key' => [
                                                        'type' => 'use_field',
                                                        'name' => esc_html__('Select field', 'utillz-core'),
                                                        'group' => 'any',
                                                        'include' => [
                                                            'ulz_price' => esc_html__('Price', 'utillz-core'),
                                                        ]
                                                    ],
                                                    'format' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__('Format', 'utillz-core'),
                                                        'description' => esc_html__('{field} will be replaced with the field value. You can add additional text, example format: "{field} bedrooms", will print "4 bedrooms".', 'utillz-core'),
                                                        'value' => '{field}'
                                                    ],
                                                    'icon' => [
                                                        'type' => 'icon',
                                                        'name' => esc_html__('Icon', 'utillz-core'),
                                                    ],
                                                    'type' => [
                                                        'type' => 'select',
                                                        'name' => esc_html__('Type', 'utillz-core'),
                                                        'options' => [
                                                            'text' => esc_html__('Text', 'utillz-core'),
                                                            'address' => esc_html__('Address', 'utillz-core'),
                                                            'url' => esc_html__('URL', 'utillz-core'),
                                                            'email' => esc_html__('Email', 'utillz-core'),
                                                            'phone' => esc_html__('Phone number', 'utillz-core'),
                                                            'price' => esc_html__('Price', 'utillz-core'),
                                                        ],
                                                        'allow_empty' => false
                                                    ],
                                                    'type_url_label' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__( 'URL text', 'utillz-core' ),
                                                        'dependency' => [
                                                            'id' => 'type',
                                                            'compare' => '=',
                                                            'value' => [ 'url' ],
                                                        ],
                                                    ],
                                                ]
                                            ],
                                        ]
                                    ]

                                ]
                            ],

                            /*
                             * report
                             *
                             */
                            'report' => [
                                'name' => esc_html__('Report', 'utillz-core'),
                                'fields' => [
                                    'fields' => [

                                        'type' => 'repeater',
                                        'id' => 'report_fields',
                                        'name' => esc_html__('Report fields', 'utillz-core'),
                                        'button' => [
                                            'label' => esc_html__('Add field', 'utillz-core')
                                        ],
                                        'templates' => [

                                            'field' => [
                                                'name' => esc_html__('Report field', 'utillz-core'),
                                                'heading' => 'name',
                                                'fields' => [
                                                    'name' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__( 'Report field name', 'utillz-core' ),
                                                    ],
                                                    'key' => [
                                                        'type' => 'auto-key',
                                                    ],
                                                ]
                                            ],

                                        ],
                                    ]
                                ]
                            ],

                        ], apply_filters('utillz/modules/listing/action', []))
                    ]);

                    $panel = Panel::instance();
						$form = $panel->getForm();

						$form->render([
                        'type' => 'checkbox',
                        'id' => 'enable_action_sticky',
                        'name' => esc_html__('Enable sticky action', 'utillz-core'),
                        'description' => __('Enable this option if you want to stick the action sidebar to your screen when scrolling.', 'utillz-core'),
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'pricing'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e('Pricing', 'utillz-core'); ?></h3>
            </div>

            <div class="ulz-form ulz-grid">

                <?php

                    $panel = Panel::instance();
						$form = $panel->getForm();

						$form->render([
                        'type' => 'checkbox',
                        'id' => 'allow_pricing',
                        'name' => esc_html__('Allow pricing', 'utillz-core'),
                        'description' => esc_html__('Check this option if you want to display pricing in your listings. The pricing will automatically appear in your submission for and listings.', 'utillz-core'),
                    ]);

                     $form->render([
                        'type' => 'checkbox',
                        'id' => 'allow_not_required_price',
                        'name' => esc_html__('Price is not required', 'utillz-core'),
                        'description' => esc_html__('Check this option if your listings can be for free.', 'utillz-core'),
                        'dependency' => [
                            'id' => 'allow_pricing',
                            'compare' => '=',
                            'value' => true,
                        ],
                    ]);

                    $form->render([
                        'type' => 'checkbox',
                        'id' => 'allow_extra_pricing',
                        'name' => esc_html__( 'Allow extra pricing', 'utillz-core' ),
                        'description' => esc_html__( 'Check this if you want to allow the users to add additional prices like additional fees.', 'utillz-core' ),
                        'dependency' => [
                            'id' => 'allow_pricing',
                            'compare' => '=',
                            'value' => true,
                        ],
                    ]);

                    $form->render([
                        'type' => 'checkbox',
                        'id' => 'allow_addons',
                        'name' => esc_html__( 'Allow addons', 'utillz-core' ),
                        'description' => esc_html__( 'Check this if you want to allow the users to add additional addon prices like airport pickup.', 'utillz-core' ),
                        'dependency' => [
                            'id' => 'allow_pricing',
                            'compare' => '=',
                            'value' => true,
                        ],
                    ]);

                   $form->render([
                        'type' => 'text',
                        'id' => 'addon_label',
                        'name' => esc_html__( 'Addon label', 'utillz-core' ),
                        'placeholder' => esc_html__( 'Select services', 'utillz-core' ),
                        'dependency' => [
                            'id' => 'allow_pricing',
                            'compare' => '=',
                            'value' => true,
                        ],
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'reviews'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e('Reviews', 'utillz-core'); ?></h3>
            </div>

            <div class="ulz-form ulz-grid">

                <?php
                     $panel = Panel::instance();
						$form = $panel->getForm();
                    $form->render([
                        'type' => 'heading',
                        'description' => __('Customize your reviews, add ratings, enable media upload. Don\'t forget to add the review module inside the single page by going to <strong>Display > Single Page > Content > add the "Review" module</strong>.', 'utillz-core'),
                    ]);

                    $form->render([
                        'type' => 'select',
                        'id' => 'review_submission',
                        'name' => esc_html__('Review submission', 'utillz-core'),
                        'options' => [
                            'everyone' => esc_html__('Everyone can submit a review', 'utillz-core'),
                            'engaged' => esc_html__('Only engaged users', 'utillz-core'),
                        ],
                        'value' => 'everyone',
                        'allow_empty' => false
                    ]);

                    $form->render([
                        'type' => 'number',
                        'id' => 'reviews_per_page',
                        'name' => esc_html__('Reviews per page', 'utillz-core'),
                        'input_type' => 'stepper',
                        'style' => 'v2',
                        'min' => 1,
                        'max' => 50,
                        'value' => 10,
                    ]);

                    $form->render([
                        'type' => 'checkbox',
                        'id' => 'review_moderation',
                        'name' => esc_html__('Comment must be manually approved', 'utillz-core'),
                    ]);

                    $form->render([
                        'type' => 'checkbox',
                        'id' => 'multiple_reviews',
                        'name' => esc_html__('Users can submit multiple reviews on listings', 'utillz-core'),
                    ]);

                        $form->render([
                        'type' => 'checkbox',
                        'id' => 'enable_review_media',
                        'name' => esc_html__('Enable media uploads', 'utillz-core'),
                        'description' => esc_html__('Allow users to upload images to their reviews.', 'utillz-core'),
                    ]);

                     $form->render([
                        'type' => 'checkbox',
                        'id' => 'enable_review_ratings',
                        'name' => esc_html__('Enable review ratings', 'utillz-core'),
                    ]);

                    $form->render([
                        'type' => 'repeater',
                        'id' => 'review_ratings',
                        'name' => esc_html__('Add rating criteria', 'utillz-core'),
                        'button' => [
                            'label' => esc_html__('Add criteria', 'utillz-core')
                        ],
                        'templates' => [

                            /*
                             * rating
                             *
                             */
                            'rating' => [
                                'name' => esc_html__('Rating', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__( 'Name', 'utillz-core' ),
                                        'value' => 'Rating Name',
                                    ],
                                    'key' => [
                                        'type' => 'auto-key',
                                        'name' => esc_html__( 'Key', 'utillz-core' ),
                                        'defined' => false,
                                    ],
                                ]
                            ],

                        ],
                        'dependency' => [
                            'id' => 'enable_review_ratings',
                            'compare' => '=',
                            'value' => true,
                            'style' => 'ulz-opacity-30',
                        ],
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'related'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e('Related Listings', 'utillz-core'); ?></h3>
            </div>

            <div class="ulz-form ulz-grid">

                <?php
            $panel = Panel::instance();
						$form = $panel->getForm();
                   $form->render([
                        'type' => 'checkbox',
                        'id' => 'enable_related',
                        'name' => esc_html__('Enable related listings', 'utillz-core'),
                    ]);

                    $form->render([
                        'type' => 'taxonomy_types',
                        'id' => 'related_taxonomy',
                        'name' => esc_html__('Related by', 'utillz-core'),
                        'allow_empty' => false,
                        'dependency' => [
                            'id' => 'enable_related',
                            'compare' => '=',
                            'value' => 1,
                            'style' => 'ulz-opacity-30',
                        ],
                    ]);

                    $form->render([
                        'type' => 'number',
                        'id' => 'related_posts_per_page',
                        'name' => esc_html__('Related — number of posts', 'utillz-core'),
                        'input_type' => 'stepper',
                        'style' => 'v2',
                        'min' => 1,
                        'max' => 50,
                        'value' => 3,
                        'dependency' => [
                            'id' => 'enable_related',
                            'compare' => '=',
                            'value' => 1,
                            'style' => 'ulz-opacity-30',
                        ],
                    ]);

                    do_action('utillz/settings/listing-type/related');

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

    </section>

    <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'display'}">

        <aside class="ulz-section" :class="{'ulz-none': tabSub !== 'box'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'Listing box', 'utillz-core' ); ?></h3>
            </div>

            <div class="ulz-grid">

                <?php
                      $panel = Panel::instance();
						$form = $panel->getForm();
                    $form->render([
                        'type' => 'preview_listing',
                        'id' => 'preview_listing',
                        'name' => esc_html__('Preview', 'utillz-core'),
                    ]);

                ?>

            </div>
        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'single'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'Single Page', 'utillz-core' ); ?></h3>
            </div>

            <div class="ulz-grid">

                <?php
					$panel = Panel::instance();
					$form = $panel->getForm();
                    $form->render([
                        'type' => 'select',
                        'id' => 'single_cover_type',
                        'name' => esc_html__('Cover type', 'utillz-core'),
                        'value' => 'none',
                        'options' => apply_filters('utillz/listing-type/display/cover-type', [
                            'none' => esc_html__('Do not display any cover', 'utillz-core'),
                            'default' => esc_html__('Default', 'utillz-core'),
                        ]),
                        'allow_empty' => false
                    ]);

                    $form->render([
                        'type' => 'tab',
                        'id' => 'tab_content',
                        'name' => esc_html__('Content', 'utillz-core'),
                    ]);

                    $form->render([
                        'type' => 'repeater',
                        'id' => 'display_single_content',
                        'name' => esc_html__('Content', 'utillz-core'),
                        'templates' => [

                            'text' => [
                                'name' => esc_html__('Static content — free text', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                    ],
                                    'content' => [
                                        'type' => 'textarea',
                                        'name' => esc_html__('Content', 'utillz-core'),
                                    ],
                                ]
                            ],

                            'content' => [
                                'name' => esc_html__('Content', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'use_field',
                                        'name' => esc_html__('Select field', 'utillz-core'),
                                        'col' => 6
                                    ],
                                    'read_more' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__('Enable read more toggle', 'utillz-core'),
                                        'description' => esc_html__('This option will help you to improve the listing readability. A new button will appear and when you click it, the content area will expand.', 'utillz-core'),
                                    ],
                                ]
                            ],

                            'taxonomy' => [
                                'name' => esc_html__('Taxonomy', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'use_field',
                                        'group' => 'taxonomy',
                                        'name' => esc_html__('Select field', 'utillz-core'),
                                        'col' => 6
                                    ],
                                    'style' => [
                                        'type' => 'select',
                                        'name' => esc_html__('Style', 'utillz-core'),
                                        'options' => [
                                            'tags' => esc_html__('Tags', 'utillz-core'),
                                            'inline' => esc_html__('Inline', 'utillz-core'),
                                            'list' => esc_html__('List', 'utillz-core'),
                                        ],
                                        'value' => 'tags',
                                        'allow_empty' => false
                                    ],
                                ]
                            ],

                            'bullets' => [
                                'name' => esc_html__('List', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                        'col' => 6
                                    ],
                                    'style' => [
                                        'type' => 'select',
                                        'name' => esc_html__('Style', 'utillz-core'),
                                        'options' => [
                                            'inline' => esc_html__('Inline', 'utillz-core'),
                                            'columns' => esc_html__('Columns', 'utillz-core'),
                                            'table' => esc_html__('Table', 'utillz-core'),
                                        ],
                                        'value' => 'inline',
                                        'allow_empty' => false,
                                        'col' => 6
                                    ],
                                    'num_columns' => [
                                        'type' => 'number',
                                        'name' => esc_html__( 'Number of columns', 'utillz-core' ),
                                        'min' => 2,
                                        'max' => 3,
                                        'input_type' => 'stepper',
                                        'style' => 'v2',
                                        'dependency' => [
                                            'id' => 'style',
                                            'compare' => '=',
                                            'value' => 'columns',
                                        ],
                                    ],

                                    'items' => [
                                        'type' => 'repeater',
                                        'name' => esc_html__('Meta items', 'utillz-core'),
                                        'templates' => [

                                            'item' => [
                                                'name' => 'Item',
                                                'heading' => 'name',
                                                'fields' => [
                                                    'name' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__('Name', 'utillz-core'),
                                                    ],
                                                    'key' => [
                                                        'type' => 'use_field',
                                                        'name' => esc_html__('Select field', 'utillz-core'),
                                                        'group' => 'any',
                                                        'include' => [
                                                            'ulz_price' => esc_html__('Price', 'utillz-core'),
                                                        ]
                                                    ],
                                                    'format' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__('Format', 'utillz-core'),
                                                        'description' => esc_html__('{field} will be replaced with the field value. You can add additional text, example format: "{field} bedrooms", will print "4 bedrooms".', 'utillz-core'),
                                                        'value' => '{field}'
                                                    ],
                                                    'icon' => [
                                                        'type' => 'icon',
                                                        'name' => esc_html__('Icon', 'utillz-core'),
                                                    ],
                                                    'type' => [
                                                        'type' => 'select',
                                                        'name' => esc_html__('Type', 'utillz-core'),
                                                        'options' => [
                                                            'text' => esc_html__('Text', 'utillz-core'),
                                                            'address' => esc_html__('Address', 'utillz-core'),
                                                            'url' => esc_html__('URL', 'utillz-core'),
                                                            'email' => esc_html__('Email', 'utillz-core'),
                                                            'phone' => esc_html__('Phone number', 'utillz-core'),
                                                            'price' => esc_html__('Price', 'utillz-core'),
                                                        ],
                                                        'allow_empty' => false
                                                    ],
                                                    'type_url_label' => [
                                                        'type' => 'text',
                                                        'name' => esc_html__( 'URL text', 'utillz-core' ),
                                                        'dependency' => [
                                                            'id' => 'type',
                                                            'compare' => '=',
                                                            'value' => [ 'url' ],
                                                        ],
                                                    ],
                                                ]
                                            ],
                                        ]
                                    ]

                                ]
                            ],

                            'location' => [
                                'name' => esc_html__('Location', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                    ],
                                    'show_address' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__('Show address', 'utillz-core'),
                                    ],
                                ]
                            ],

                            'reviews' => [
                                'name' => esc_html__('Reviews', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                    ],
                                ]
                            ],

                            'author' => [
                                'name' => esc_html__('Author', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                    ],
                                    'display_contact' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__('Display contact button', 'utillz-core'),
                                        'value' => true
                                    ],
                                    'display_public_profile' => [
                                        'type' => 'checkbox',
                                        'name' => esc_html__('Display public profile button', 'utillz-core'),
                                        'value' => true
                                    ],
                                ]
                            ],

                            'menu' => [
                                'name' => esc_html__('Menu', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                    ],
                                ]
                            ],

                            'gallery' => [
                                'name' => esc_html__('Gallery', 'utillz-core'),
                                'heading' => 'name',
                                'fields' => [
                                    'name' => [
                                        'type' => 'text',
                                        'name' => esc_html__('Name', 'utillz-core'),
                                    ],
                                    'display' => [
                                        'type' => 'select',
                                        'name' => esc_html__('Display', 'utillz-core'),
                                        'options' => [
                                            'adaptive' => esc_html__('Adaptive gallery', 'utillz-core'),
                                            'files' => esc_html__('Downloadable files', 'utillz-core'),
                                        ],
                                        'allow_empty' => false,
                                        'col' => 6
                                    ],
                                    'key' => [
                                        'type' => 'use_field',
                                        'name' => esc_html__('Select field', 'utillz-core'),
                                        'group' => 'media',
                                        'col' => 6
                                    ],
                                ]
                            ],
                        ]
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'marker'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'Map Marker', 'utillz-core' ); ?></h3>
            </div>

            <div class="ulz-grid">

                <?php

                    $form->render([
                        'type' => 'preview_marker',
                        'id' => 'preview_marker',
                        'name' => esc_html__('Preview', 'utillz-core'),
                    ]);

                ?>

            </div>
        </aside>

    </section>

    <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'explore'}">

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'general'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'General', 'utillz-core' ); ?></h3>
            </div>

            <div class="ulz-form ulz-grid">

                <?php

                    $form->render([
                        'type' => 'checkbox',
                        'id' => 'hide_global',
                        'name' => esc_html__('Exclude from global search', 'utillz-core'),
                        'description' => esc_html__('This option will exclude the listing type from the global explore page', 'utillz-core'),
                    ]);

                    $form->render([
                        'type' => 'select',
                        'id' => 'search_form',
                        'name' => esc_html__( 'Select search form', 'utillz-core' ),
                        'description' => esc_html__( 'Filters will appear when you explore the listing type.', 'utillz-core' ),
                        'options' => [
                            'query' => [
                                'post_type' => 'ulz_search_form',
                                'posts_per_page' => -1,
                            ]
                        ],
                        'col' => 6
                    ]);

                    $form->render([
                        'type' => 'select',
                        'id' => 'search_form_more',
                        'name' => esc_html__( 'Select search form (more)', 'utillz-core' ),
                        'description' => esc_html__( 'Additional filters that will appear in a popup.', 'utillz-core' ),
                        'options' => [
                            'query' => [
                                'post_type' => 'ulz_search_form',
                                'posts_per_page' => -1,
                            ]
                        ],
                        'col' => 6
                    ]);

                    $form->render([
                        'type' => 'number',
                        'id' => 'listings_per_page',
                        'name' => esc_html__('Listings per page', 'utillz-core'),
                        'input_type' => 'stepper',
                        'format' => '%s listings',
                        'style' => 'v2',
                        'min' => 1,
                        'max' => 50,
                        'step' => 1,
                        'value' => 10,
                        'col' => 6
                    ]);

                    $form->render([
                        'type' => 'select',
                        'id' => 'pagination_type',
                        'name' => esc_html__('Pagination type', 'utillz-core'),
                        'options' => [
                            'paging' => esc_html__('Paging', 'utillz-core'),
                            'more' => esc_html__('Load more button', 'utillz-core'),
                            'infinity' => esc_html__('Infinity scroll', 'utillz-core'),
                        ],
                        'allow_empty' => false,
                        'col' => 6
                    ]);

                    $form->render([
                        'type' => 'select',
                        'id' => 'explore_open',
                        'name' => esc_html__('Explore open type', 'utillz-core'),
                        'options' => apply_filters('utillz/listing-type/settings/explore/open', [
                            'normal' => esc_html__('Normal', 'utillz-core'),
                            'new_tab' => esc_html__('New tab', 'utillz-core'),
                        ]),
                        'allow_empty' => false
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

    </section>

    <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'monetize'}">

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'plans'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'Plans', 'utillz-core' ); ?></h3>
                <p>
                    <?php esc_html_e( 'Plans are a simple WooCommerce products created with the type "Listing Plan". By adding plans to specif listing type, the customers will be asked to select one in the submission process.', 'utillz-core' ); ?>
                </p>
            </div>

            <div class="ulz-form ulz-grid">

                <?php

                    $form->render([
                        'type' => 'checkbox',
                        'id' => 'enable_plans',
                        'name' => esc_html__( 'Enable plans for this listing type', 'utillz-core' ),
                    ]);

                    $form->render([
                        'type' => 'wc_products',
                        'id' => 'plans',
                        'name' => esc_html__( 'Select plan', 'utillz-core' ),
                        'product_type' => [
                            'listing_plan',
                            'listing_subscription_plan',
                        ],
                        'choice' => 'checklist',
                        'allow_empty' => false,
                        'error_message' => esc_html__( 'There are no available plans, you can create one by going to Products, then add new product of type `Listing Package`', 'utillz-core' ),
                        'dependency' => [
                            'id' => 'enable_plans',
                            'compare' => '=',
                            'value' => 1,
                            'style' => 'ulz-opacity-30',
                        ],
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'promotions'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'Promotions', 'utillz-core' ); ?></h3>
                <p>
                    <?php esc_html_e( 'Promotions promotion are a simple WooCommerce products created with the type "Listing Promotion". By adding packages to specif listing type, the customers will be able to boost their listings in the search results for limited time.', 'utillz-core' ); ?>
                </p>
            </div>

            <div class="ulz-form ulz-grid">

                <?php

                    $form->render([
                        'type' => 'checkbox',
                        'id' => 'enable_promotions',
                        'name' => esc_html__( 'Enable promotions for this listing type', 'utillz-core' ),
                    ]);

                    $form->render([
                        'type' => 'wc_products',
                        'id' => 'promotions',
                        'name' => esc_html__( 'Select promotion packages', 'utillz-core' ),
                        'product_type' => 'listing_promotion',
                        'choice' => 'checklist',
                        'allow_empty' => false,
                        'error_message' => esc_html__( 'There are no available promotions, you can create one by going to Products, then add new product of type `Listing Promotion`', 'utillz-core' ),
                        'dependency' => [
                            'id' => 'enable_promotions',
                            'compare' => '=',
                            'value' => 1,
                            'style' => 'ulz-opacity-30',
                        ],
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>

        <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'payments'}">

            <div class="ulz-panel-heading">
                <h3 class="ulz-title"><?php esc_html_e( 'Payments', 'utillz-core' ); ?></h3>
                <p>
                    <?php esc_html_e( 'Fees will affect the final price of the listings', 'utillz-core' ); ?>
                </p>
            </div>

            <div class="ulz-form ulz-grid">
                <div class="ulz-col-6">
                    <div class="ulz-grid">
                        <?php

                            $form->render([
                                'type' => 'select',
                                'id' => 'service_fee_type',
                                'name' => esc_html__( 'Service fee type', 'utillz-core' ),
                                'description' => esc_html__( 'The service fee will be deducted from the buyers', 'utillz-core' ),
                                'value' => 'none',
                                'options' => [
                                    'none' => esc_html__('No fee', 'utillz-core'),
                                    'fixed' => esc_html__('Fixed amount', 'utillz-core'),
                                    'percentage' => esc_html__('Percentage', 'utillz-core'),
                                ],
                                'allow_empty' => false,
                            ]);

                            $form->render([
                                'type' => 'number',
                                'id' => 'service_fee_amount_fixed',
                                'name' => esc_html__( 'Service fee amount', 'utillz-core' ),
                                'description' => esc_html__( 'Number only', 'utillz-core' ),
                                'min' => 0.01,
                                'step' => 0.01,
                                'dependency' => [
                                    [
                                        'id' => 'service_fee_type',
                                        'compare' => '=',
                                        'value' => 'fixed',
                                    ]
                                ],
                            ]);

                            $form->render([
                                'type' => 'number',
                                'id' => 'service_fee_amount_percentage',
                                'name' => esc_html__( 'Service fee amount (percentage)', 'utillz-core' ),
                                'description' => esc_html__( 'Number only', 'utillz-core' ),
                                'min' => 0.01,
                                'max' => 100,
                                'step' => 0.01,
                                'dependency' => [
                                    [
                                        'id' => 'service_fee_type',
                                        'compare' => '=',
                                        'value' => 'percentage',
                                    ]
                                ],
                            ]);

                        ?>
                    </div>
                </div>
                <div class="ulz-col-6">
                    <div class="ulz-grid">
                        <?php

                            $form->render([
                                'type' => 'select',
                                'id' => 'host_fee_type',
                                'name' => esc_html__( 'Owner fee type', 'utillz-core' ),
                                'description' => esc_html__( 'The owner fee will be deducted from the publisher of the listing', 'utillz-core' ),
                                'value' => 'none',
                                'options' => [
                                    'none' => esc_html__('No fee', 'utillz-core'),
                                    'percentage' => esc_html__('Percentage', 'utillz-core'),
                                ],
                                'allow_empty' => false,
                            ]);

                            $form->render([
                                'type' => 'number',
                                'id' => 'host_fee_amount_percentage',
                                'name' => esc_html__( 'Host fee amount (percentage)', 'utillz-core' ),
                                'description' => esc_html__( 'Number only', 'utillz-core' ),
                                'min' => 0.01,
                                'max' => 100,
                                'step' => 0.01,
                                'dependency' => [
                                    [
                                        'id' => 'host_fee_type',
                                        'compare' => '=',
                                        'value' => 'percentage',
                                    ]
                                ],
                            ]);

                        ?>
                    </div>
                </div>

                <?php

                    $form->render([
                        'type' => 'select',
                        'id' => 'payment_processing',
                        'name' => esc_html__( 'Payment processing', 'utillz-core' ),
                        'description' => esc_html__( 'Select the type of payment collection when a payment is made', 'utillz-core' ),
                        'options' => Ucore()->get_payment_processing_types(),
                        'value' => 'full',
                        'allow_empty' => false
                    ]);

                    $form->render([
                        'type' => 'number',
                        'id' => 'payment_processing_percentage',
                        'name' => esc_html__( 'Payment processing percentage', 'utillz-core' ),
                        'description' => esc_html__( 'Number only', 'utillz-core' ),
                        'min' => 0.01,
                        'max' => 100,
                        'step' => 0.01,
                        'dependency' => [
                            [
                                'id' => 'payment_processing',
                                'compare' => '=',
                                'value' => 'percentage',
                            ]
                        ],
                    ]);

                ?>

                <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                    <button type="submit" class="ulz-button ulz--large">
                        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                    </button>
                </div>

            </div>
        </aside>
    </section>
</div>

<?php Ucore()->the_template('admin/panel/modal/field-webhook'); ?>